ALTER TABLE `editor_data_files` MODIFY COLUMN data_checks TEXT DEFAULT NULL;
ALTER TABLE `editor_data_files` MODIFY COLUMN missing_data TEXT DEFAULT NULL;
ALTER TABLE `editor_data_files` MODIFY COLUMN notes TEXT DEFAULT NULL;

ALTER TABLE `editor_data_files` MODIFY COLUMN metadata TEXT DEFAULT NULL;


# Add pid and wgt columns to editor_collections
ALTER TABLE `editor_collections` add pid int DEFAULT NULL;
ALTER TABLE `editor_collections` add wgt int DEFAULT NULL;
ALTER TABLE `editor_collections` ADD UNIQUE index `idx_title_pid` (`title`,`pid`);


# Add fulltext index to editor_projects
ALTER TABLE `editor_projects` 
ADD FULLTEXT INDEX `ft_projects` (`title`) ;


ALTER TABLE `audit_logs` 
ADD COLUMN `metadata` JSON NULL;

ALTER TABLE `audit_logs` 
CHANGE COLUMN `description` `action_type` VARCHAR(10) NOT NULL ;


CREATE TABLE `editor_template_acl` (
  `id` int NOT NULL AUTO_INCREMENT,
  `template_id` int NOT NULL,
  `permissions` varchar(100) DEFAULT NULL,
  `user_id` int NOT NULL,
  `created` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1;



ALTER TABLE `editor_templates` 
ADD COLUMN `created_by` INT;

ALTER TABLE `editor_templates` 
ADD COLUMN `changed_by` INT;

ALTER TABLE `editor_templates`
ADD COLUMN `owner_id` INT;

ALTER TABLE `editor_templates`
ADD COLUMN `is_private` INT NULL;

ALTER TABLE `editor_templates`
ADD COLUMN `is_published` INT NULL;

ALTER TABLE `editor_templates`
ADD COLUMN `is_deleted` INT NULL AFTER `is_published`,
ADD COLUMN `deleted_by` INT NULL AFTER `is_deleted`,
ADD COLUMN `deleted_at` INT NULL AFTER `deleted_by`;


update editor_templates set created_by=1 where created_by is null;
update editor_templates set owner_id=created_by where owner_id is null;


drop table `edit_history`;
CREATE TABLE `edit_history` (
  `id` int NOT NULL AUTO_INCREMENT,
  `obj_type` varchar(15) NOT NULL,
  `obj_id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `action_type` varchar(10) NOT NULL,
  `created` INT DEFAULT NULL,
  `metadata` json DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb3;


ALTER TABLE `editor_data_files` 
ADD COLUMN `store_data` INT NULL;


ALTER TABLE `editor_data_files` 
ADD COLUMN `created` INT NULL AFTER `store_data`,
ADD COLUMN `changed` INT NULL AFTER `created`,
ADD COLUMN `created_by` INT NULL AFTER `changed`,
ADD COLUMN `changed_by` INT NULL AFTER `created_by`;


# 2025/02/11
# admin metadata types

drop table `metadata_schemas`;  
drop TABLE `metadata_types`;
drop TABLE `metadata_types_acl`;
drop TABLE `metadata_types_data`;



CREATE TABLE `admin_metadata` (
  `id` int NOT NULL AUTO_INCREMENT,
  `template_id` int DEFAULT NULL,
  `sid` int DEFAULT NULL,
  `metadata` json DEFAULT NULL,
  `created_by` int DEFAULT NULL,
  `changed_by` int DEFAULT NULL,
  `created` int DEFAULT NULL,
  `changed` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `meta_unq` (`template_id`,`sid`)
) ENGINE=InnoDB AUTO_INCREMENT=1;

CREATE TABLE `admin_metadata_acl` (
  `id` int NOT NULL AUTO_INCREMENT,
  `template_id` int NOT NULL,
  `permissions` varchar(100) DEFAULT NULL,
  `user_id` int NOT NULL,
  `created` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1;

# 2025/02/15
CREATE TABLE `admin_metadata_projects` (
  `id` int NOT NULL AUTO_INCREMENT,
  `sid` int DEFAULT NULL,
  `template_id` int DEFAULT NULL,
  PRIMARY KEY (`id`)
);

# 2025/03/31
ALTER TABLE `audit_logs` 
CHANGE COLUMN `obj_type` `obj_type` VARCHAR(25) NOT NULL ;

ALTER TABLE `audit_logs` 
CHANGE COLUMN `action_type` `action_type` VARCHAR(25) NOT NULL ;

ALTER TABLE `editor_projects` 
ADD COLUMN `attributes` JSON NULL;

ALTER TABLE `editor_variables`
ADD COLUMN `is_key` INT NULL;


# 2025/06/07
ALTER TABLE `audit_logs`
ADD COLUMN `obj_ref_id` INT NULL;


# 2025/06/19
# project versions

ALTER TABLE `editor_projects` 
ADD COLUMN `pid` INT NULL AFTER `study_idno`,
ADD COLUMN `is_locked` INT NULL AFTER `pid`,
ADD COLUMN `version_created` INT NULL AFTER `is_locked`,
ADD COLUMN `version_created_by` INT NULL AFTER `version_created`,
ADD COLUMN `version_notes` VARCHAR(500) NULL AFTER `version_created_by`,
ADD COLUMN `version_number` VARCHAR(15) NULL AFTER `study_idno`,
ADD UNIQUE INDEX `unq_idno` (`idno` ASC, `version_number` ASC);


