<?php
/**
 * Hook: ensure_database_exists
 * Description: Creates the configured database if it does not exist yet.
 * Triggered during: pre_system (before anything else in CI)
 */

function ensure_database_exists()
{
    // Load the database configuration manually
    $dbConfigPath = APPPATH . 'config/database.php';
    if (!file_exists($dbConfigPath)) {
        show_error('Database configuration file not found.');
    }

    require $dbConfigPath;

    $active_group = isset($active_group) ? $active_group : 'default';
    if (!isset($db[$active_group])) {
        show_error("Database config group '$active_group' not found.");
    }

    $config = $db[$active_group];

    $host = $config['hostname'];
    $user = $config['username'];
    $pass = $config['password'];

    //var_dump($host, $user, $pass); //
    $dbName = $config['database'];

    // Connect to MySQL without selecting a database
    $mysqli = @new mysqli($host, $user, $pass, '');

    if ($mysqli->connect_error) {
        log_message('error', 'MySQL connection failed: ' . $mysqli->connect_error);
        show_error('Unable to connect to MySQL server.');
    }

    // Create the database if it doesn't exist
    $query = "CREATE DATABASE IF NOT EXISTS `$dbName` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci";

    if (!$mysqli->query($query)) {
        log_message('error', 'Database creation failed: ' . $mysqli->error);
        show_error('Failed to create application database.');
    }

    $mysqli->close();
}
