<h1>Terms of Use</h1>
<p>Data disseminated by the World Bank under its Open Data policy are provided under the <a href="http://data.worldbank.org/summary-terms-of-use" target="_blank">Open Data terms of use</a>. These terms of use apply to data provided through our <a href="http://data.worldbank.org/data-catalog" target="_blank">Data Catalog</a>. A number of concerns prevent the World Bank from providing similar unconditional and unrestricted access to microdata. </p>

<ul class="bl">
<li>Microdata are unit-level data obtained from sample surveys, censuses, and administrative systems. They provide information about characteristics of individual people or entities such as households, business enterprises, facilities, farms or even geographical areas such as villages or towns. One main concern is the need to protect, as far as possible, the privacy of the individual respondents that have provided the data. Much of the microdata have been collected under a mandate provided by different kinds of national statistical legislation, which contain requirements for data about individuals to be treated as confidential by anyone collecting and using such data.  Further, the microdata may be protected by copyright or other intellectual property protections under different intellectual property legislation. The Microdata Library adopts rules and procedures that are consistent with the type of legislation concerning this information around the world.</li>
<li>The Microdata Library operates as a portal. It disseminates micro-datasets from two sources: those that belong to the World Bank and those where the data have been generated and are owned by another agency. A number of micro-datasets have been provided to the Microdata Library by third parties including member states, international or regional agencies, and World Bank contractors. In many cases the arrangements that have allowed the datasets to be made available to the World Bank include limitations on how the data can be disseminated to users. The Microdata Library is obliged to put these arrangements into effect.</li> </ul>
<p>For these reasons, the Microdata Library disseminates data under some restrictions, the terms of which vary by source, as well as according to the individual characteristics of each microdata set. While the Microdata Library remains governed by the Terms of Use for the World Bank's datasets, it is subject to additional terms, described below. If these additional Microdata terms are inconsistent with the general Terms of Use, then these specific Microdata terms shall govern.</p> 
<p>To protect the confidentiality of individual information and to meet the requirements of the data owners who provide the microdata sets, the Microdata Library has various types of access that may be applied to specific datasets. The various possible access policies under which data may be made accessible include direct access, public use files, licensed files, files accessible in a data enclave and policy defined by an external repository. Other data dissemination options are possible, although not currently implemented by the Microdata Library. These various options are described in generic terms below; the exact formulation of these policies may differ when applied by external contributing repositories.</p>
<p>Regardless of the access method in place for any dataset, all potential users are required to agree to a disclaimer, in which they agree to follow the Terms of Use applicable to the Microdata Library, and acknowledge that the original collector of the data, the Microdata Library and the relevant funding agency bear no responsibility for any use of the data or for interpretations or inferences based upon such uses.</p> <p>The World Bank makes no claim about the quality of the data or its suitability for any type of analysis or use. The World Bank shall have the right, but no obligation, to monitor use of microdata obtained from the Microdata Library, and may decide, in its discretion, whether an abuse has taken place. The World Bank shall have absolute discretion to determine whether to sanction users for violations, and penalties may include restrictions or denial of further access to the Microdata Library, or any other World Bank Group resources.</p>
<p>Each item in the Microdata Library shall be subject to one of the following access and use categories, and users must agree to comply with those conditions associated with the items they wish to access.</p>


  <!-- tabs -->
  <ul class="nav nav-tabs mb-3" role="tablist">
    <li class="nav-item">
      <a class="nav-link wb-text-link-uppercase active" data-toggle="tab" href="#open_access" role="tab">Open Access</a>
    </li>
    <li class="nav-item">
      <a class="nav-link wb-text-link-uppercase" data-toggle="tab" href="#direct_access" role="tab">Direct Access</a>
    </li>
    <li class="nav-item">
      <a class="nav-link wb-text-link-uppercase" data-toggle="tab" href="<?php echo site_url('terms-of-use');?>#public_use" role="tab">Public Use</a>
    </li>
    <li class="nav-item">
      <a class="nav-link wb-text-link-uppercase" data-toggle="tab" href="#licensed" role="tab">Licensed</a>
    </li>
    <li class="nav-item">
      <a class="nav-link wb-text-link-uppercase" data-toggle="tab" href="#data-enclave" role="tab">Enclave</a>
    </li>
    <li class="nav-item">
      <a class="nav-link wb-text-link-uppercase" data-toggle="tab" href="#external" role="tab">External</a>
    </li>
    <li class="nav-item">
      <a class="nav-link wb-text-link-uppercase" data-toggle="tab" href="#no-access" role="tab">no Access</a>
    </li>
  </ul>
  
  <div class="tab-content">
            
    <div id="open_access" class="tab-pane active" role="tabpanel" >
      <p>Datasets and the related documentation are made available freely to users. There is no need to be being logged into the application.</p>
      <div>
        <ul class="bl">
          <li>You are free to copy, distribute, adapt, display or include the data in other products for commercial and noncommercial purposes at no cost subject to certain limitations summarized below.
          </li><li>You must include attribution for the data you use in the manner indicated in the metadata included with the data.
          </li><li>You must not claim or imply that The World Bank endorses your use of the data by or use The World Bank's logo(s) or trademark(s) in conjunction with such use.
          </li><li>Other parties may have ownership interests in some of the materials contained on The World Bank Web site. For example, 
          we maintain a list of some specific data within the Datasets that you may not redistribute or reuse without first contacting the original content provider, 
          as well as information regarding how to contact the original content provider. Before incorporating any data in other products, please check the list: <a target="_blank" href="http://www.worldbank.org/terms-datasets-restricted">Terms of use: Restricted Data</a>
          </li><li>The World Bank makes no warranties with respect to the data and you agree The World Bank shall not be liable to you in connection with your use of the data.
          </li>
        </ul>
        <p>This is only a summary of the Terms of Use for Datasets Listed in The World Bank Data Catalogue. Please read the actual agreement that controls your use of the Datasets, 
          which is available here: <a target="_blank" href="http://www.worldbank.org/terms-datasets">Terms of use for datasets</a>.  Also see 
          <a target="_blank" href="http://www.worldbank.org/terms">World Bank Terms and Conditions</a>.</p>
      </div> 
    </div>
            
    <div id="direct_access" class="tab-pane" role="tabpanel" aria-expanded="false">
      <p>Relevant datasets and the related documentation are made freely available to  registered and unregistered users under the following basic conditions.</p>
      <ul class="bl">
        <li>The data and other  materials provided by the Microdata Library will be used solely by the user, and shall not be redistributed or sold to other individuals, institutions, or  organizations without the prior written agreement of the Microdata Library or  the originating repository, and only subject to such conditions as may  accompany such consent. </li>
        <li>The data will be used for statistical and scientific research purposes only. They will be used solely for generating and  perhaps reporting, aggregated information and not for investigations into  specific individuals or organizations. In other words, the data shall be  treated as a finished product - they may be used as a foundation for further  work, but no reverse engineering or "upstream research" into the sources of the  data itself will be permitted.</li>
        <li>No attempt will be made to identify respondents or microdata providers, and no use will be made of the identity of any person, facility or establishment discovered inadvertently.  Any such discovery would immediately be reported to the Microdata Library, to  allow us to evaluate further use, apply further statistical disclosure control  methods, impose further restrictions on access, or appropriately re-classify  the data. </li>
        <li>No attempt will be made to create links among datasets provided by the Microdata Library, or among data from the Microdata Library and other datasets that could identify  individuals or organizations. </li>
        <li>Any books, articles, conference papers, theses, dissertations, reports, or other publications that employ data obtained from the Microdata Library will cite the source of data in  accordance with the Citation Requirement provided with the dataset.</li>
        <li>The original collector of the data, the Microdata Library, and the relevant funding agencies bear no responsibility for any use of the data or for interpretations or inferences  based upon such uses. </li>
      </ul>
      <p>When downloading datasets published under the <em>direct access</em> policy, users shall signify their agreement to comply with the above-stated terms and conditions  and agree that the use of statistical data obtained from the Microdata Library  will conform to these widely-accepted standards of practice and any other legal  restrictions to protect the confidentiality of respondents.</p>
    </div>            

    <div id="public_use" class="tab-pane" role="tabpanel" aria-expanded="false">
      <p><em>Public Use Files (PUFs)</em> are available to anyone agreeing to respect a core set of easy-to-meet conditions. These data are made easily accessible  because the risk of identifying individual respondents or data providers is  considered to be low. Before gaining access to these data, users are asked to  register and to read and agree on the following conditions. </p>
      <ul class="bl">
        <li>Data and other  material provided by the Microdata Library will be used solely by the user, and shall not be redistributed or sold to other individuals, institutions or  organizations without the Microdata Library's prior written agreement, and only  subject to such conditions as may accompany such consent. </li>
        <li>The data will be used  for statistical and scientific research purposes only. They will be used solely for generating, and perhaps reporting, aggregated information and not for  investigations into specific individuals or organizations. In other words, the  data shall be treated as a finished product - it may be used as a foundation  for further work, but no reverse engineering or "upstream research" into the  sources of the data itself will be permitted.</li>
        <li>No attempt will be made to identify respondents or microdata providers, and no use will be made of  the identity of any person, facility or establishment discovered inadvertently.  Any such discovery would immediately be reported to the Microdata Library, to  allow us to evaluate further use, apply further statistical disclosure control  methods, impose further restrictions on access, or appropriately re-classify  the data.</li>
        <li>No attempt will be made to create links between datasets provided by the Microdata Library, or between Microdata Library data and other datasets that could identify  individuals or organizations. </li>
        <li>Any books, articles, conference papers, theses, dissertations, reports or other publications employing data obtained from the Microdata  Library will cite the source, in line with the citation requirement provided  with the dataset. </li>
        <li>The original collector of the data, the Microdata Library, and the relevant funding agencies bear no  responsibility for any use of the data or for interpretations or inferences  based upon such uses.</li>
      </ul>
    </div>            

    <div id="licensed" class="tab-pane" role="tabpanel" >
      <p><em>Licensed files</em> are files whose dissemination is restricted to <em>bona fide</em> users - authenticated users with legitimate need to access  the data - who have received authorization to access them after submitting a  documented application and signing an agreement governing the data's use. These  users must be acting on behalf of an organization, who must take responsibility for the use. The following conditions apply (specific datasets may differ in formulation, but will have similar  principles):</p>
      <ul class="bl">
        <li>Data and other material provided by the Microdata Library will be used solely by the user, and  shall not be redistributed or sold to other individuals, institutions or organizations without the Microdata Library's prior written agreement, and only  subject to such conditions as may accompany such consent. </li>
        <li>The data will be used for statistical and scientific research purposes only. They will be used solely for generating, and perhaps reporting, aggregated information and not for investigations into specific individuals or organizations. In other words, the  data shall be treated as a finished product - it may be used as a foundation  for further work, but no reverse engineering or "upstream research" into the  sources of the data itself will be permitted.</li>
        <li>No attempt will be made to identify respondents or microdata providers, and no use will be made of the identity of any person, facility or establishment discovered inadvertently. Any such discovery would immediately be reported to the Microdata Library, to  allow us to evaluate further use, apply further statistical disclosure control methods, impose further restrictions on access, or appropriately re-classify  the data.</li>
        <li>No attempt will be made to create links between datasets provided by the Microdata Library, or between Microdata Library data and other datasets that could identify  individuals or organizations. </li>
        <li>Any books, articles, conference papers, theses, dissertations, reports or other publications employing data obtained from the Microdata  Library will cite the source, in line with the citation requirement provided  with the dataset.</li>
        <li>The Microdata Library and the relevant funding agencies bear no responsibility for the data's use or for interpretation or inferences based upon it. </li>
        <li>As a condition to access Licensed Files, the user's organization must be identified, as must the principal and other researchers who will be involved in using the data at that organization. The principal researcher may be asked to sign a license on behalf of the organization. If the principal researcher is not authorized to sign on behalf of the receiving organization, a suitable representative must be  identified. Any violation of the Microdata  Terms of Use will be considered to have occurred on behalf of the user's  organization, and we will take appropriate measures to sanction such  misconduct, which may include denying any further and future access by any user  from that organization.</li>
        <li>The intended use of the data, including a list of expected outputs and the organization's dissemination policy must be identified and no different uses shall be  permitted without prior written consent from the World Bank.</li>
        <li>The World Bank shall have the right, but no obligation, to  monitor use of Microdata obtained from the Microdata Library, and may decide, in its discretion, whether an abuse has taken place.&nbsp; The World Bank shall have absolute discretion  to determine whether to sanction users for violations, and penalties may  include restrictions or denial of further access to the Microdata library, or any other World Bank Group resources.</li>
        <li>When downloading  datasets published under the licensed files policy, users shall signify their agreement to comply with the above-stated terms and conditions and agree that the use of statistical data obtained from the Microdata Library will conform to  these widely-accepted standards of practice and any other legal restrictions to protect the confidentiality of respondents.</li>
      </ul>
    </div>

    <div id="data-enclave" class="tab-pane" role="tabpanel" >
      <p>For some specialized datasets, access may only be offered through a <em>data enclave</em>. This is a facility equipped with computers not linked to the internet or an external network and from which  no information can be downloaded in any form drives. Data enclaves contain data  that are particularly sensitive or allow direct or easy identification of respondents.</p>
      <p> Users interested in accessing these datasets will be asked to complete an application form demonstrating a legitimate need to access these data to fulfill a stated statistical or  research purpose. When datasets are only available through a data enclave, arrangements will have to be made with the originating data repository for  access to be provided.</p>
      <p>The World Bank does not operate a data enclave (although Bank staff members, and researchers working with Bank staff under a Bank project, may be provided with access to datasets available to the Bank but not publicly disseminated).</p>
    </div>            

    <div id="external" class="tab-pane" role="tabpanel" >
      <p>The Microdata Library operates both as a data catalog for World Bank data and as a portal for external repositories. Datasets provided by external agencies are not owned or controlled by the Bank and have their own conditions of use. When a user accesses external repositories, these Terms and Conditions no longer apply, and the terms governing use of those external repositories shall govern access to their data.  The World Bank is not responsible in any way for the external repositories, their terms, or their collections.</p>
    </div>
    
    <div id="no-access" class="tab-pane" role="tabpanel" >
      <p>Some datasets have no access policy defined, or are not accessible. In some limited situations we may include a limited number of such datasets for the sake of completeness and for the purpose of providing access to questionnaires and reports.</p>
    </div>

  </div>






<script>
$(function(){
  //load tab via url hash
  var hash = document.location.hash;
  var prefix = "tab_";
  if (hash) {
    $('.nav-tabs a[href="'+hash.replace(prefix,"")+'"]').tab('show');
  } 
});
</script>
